<?php

declare (strict_types=1);
namespace DaHannesConnectorDeps\Sentry\Serializer\EnvelopItems;

use DaHannesConnectorDeps\Sentry\Attributes\Attribute;
use DaHannesConnectorDeps\Sentry\Event;
use DaHannesConnectorDeps\Sentry\EventType;
use DaHannesConnectorDeps\Sentry\Logs\Log;
use DaHannesConnectorDeps\Sentry\Util\JSON;
/**
 * @internal
 */
class LogsItem implements EnvelopeItemInterface
{
    public static function toEnvelopeItem(Event $event): string
    {
        $logs = $event->getLogs();
        $header = ['type' => (string) EventType::logs(), 'item_count' => \count($logs), 'content_type' => 'application/vnd.sentry.items.log+json'];
        return \sprintf("%s\n%s", JSON::encode($header), JSON::encode(['items' => array_map(static function (Log $log): array {
            return ['timestamp' => $log->getTimestamp(), 'trace_id' => $log->getTraceId(), 'level' => (string) $log->getLevel(), 'body' => $log->getBody(), 'attributes' => array_map(static function (Attribute $attribute): array {
                return ['type' => $attribute->getType(), 'value' => $attribute->getValue()];
            }, $log->attributes()->all())];
        }, $logs)]));
    }
}
