<?php

namespace DaHannesConnector\includes;

class DahannesConfig {
    private static function encrypt($value): string {
        if (!function_exists('openssl_encrypt')) {
            return base64_encode($value);
        }
        $key = wp_salt('auth');
        return openssl_encrypt($value, 'AES-256-CBC', $key, 0, substr($key, 0, 16));
    }
    
    private static function decrypt($value): string {
        if (!function_exists('openssl_decrypt')) {
            return base64_decode($value);
        }
        $key = wp_salt('auth');
        return openssl_decrypt($value, 'AES-256-CBC', $key, 0, substr($key, 0, 16));
    }
    
    public static function set_api_key($key): void {
        update_option('dahannes_api_key_encrypted', self::encrypt($key));
    }
    
    public static function get_api_key(): string {
        $encrypted = get_option('dahannes_api_key_encrypted');
        return $encrypted ? self::decrypt($encrypted) : '';
    }

    public static function migrate_existing_credentials(): void {
        $existing_key = get_option('api_key');
        if ($existing_key) {
            self::set_api_key($existing_key);
            delete_option('api_key');
        }
    }
}
