<?php

namespace DaHannesConnector\includes;

class DaHannes_Plugin_Update_Checker
{
    private $plugin_slug;
    private $plugin_version;
    private $update_url;

    public function __construct($plugin_slug, $plugin_version, $update_url)
    {
        $this->plugin_slug    = $plugin_slug;
        $this->plugin_version = $plugin_version;
        $this->update_url     = $update_url;

        add_filter('site_transient_update_plugins', [$this, 'check_for_update'],
        );
        add_filter('plugins_api', [$this, 'plugin_info'], 20, 3);
    }

    public function check_for_update($transient)
    {
        if (empty($transient->checked)) {
            return $transient;
        }

        $response = wp_remote_get($this->update_url);

        if (is_wp_error($response)
            || wp_remote_retrieve_response_code(
                $response,
            ) !== 200
        ) {
            return $transient;
        }

        $update_data = json_decode(wp_remote_retrieve_body($response));

        if ( ! isset($update_data->version)
            || version_compare(
                $this->plugin_version,
                $update_data->version,
                '>=',
            )
        ) {
            return $transient;
        }

        $transient->response[$this->plugin_slug] = (object)[
            'slug'        => $this->plugin_slug,
            'new_version' => $update_data->version,
            'url'         => isset($update_data->homepage)
                ? $update_data->homepage : '',
            'package'     => $update_data->download_url,
        ];

        return $transient;
    }

    public function plugin_info($false, $action, $args)
    {
        if ($action !== 'plugin_information'
            || $args->slug !== $this->plugin_slug
        ) {
            return $false;
        }

        $response = wp_remote_get($this->update_url);

        if (is_wp_error($response)
            || wp_remote_retrieve_response_code(
                $response,
            ) !== 200
        ) {
            return $false;
        }

        $update_data = json_decode(wp_remote_retrieve_body($response));

        return (object)[
            'name'          => $update_data->name,
            'slug'          => $update_data->slug,
            'version'       => $update_data->version,
            'author'        => 'Igor Skoric',
            'homepage'      => isset($update_data->homepage) ? $update_data->homepage : '',
            'download_link' => $update_data->download_url,
            'requires'      => $update_data->requires,
            'tested'        => $update_data->tested,
            'last_updated'  => $update_data->last_updated,
            'requires_php'  => $update_data->requires_php,
            'sections'      => [
                'description' => $update_data->sections->description,
                'changelog'   => $update_data->sections->changelog,
            ],
            'banners'   =>  [
                'low' => $update_data->banners->low,
                'high' => $update_data->banners->high,
            ]
        ];
    }
}